; Copyleft (c) n/a-n/a Azure Zanculmarktum

!define BUILDDATE "24 mars 2014"
!define APPNAME "PowerISO"
!define APP "PowerISO"
!define APPVER "0.0.0.0"
!define VER "1.1"
!define APPEXE "PowerISO.exe"
!define APPDIR "PowerISO"
!define APPEXE64 "${APPEXE}"
!define APPDIR64 "${APPDIR}64"

; === Define Registry ===
!define REGKEY1 "HKEY_CURRENT_USER\Software\PowerISO"

; === Best Compression ===
SetCompress auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize on

; === Include ===
!include Include\Launcher.nsh
!include Include\Macros.nsh

; === Set basic information ===
Name "${APPNAME} Portable"
OutFile "..\..\${APP}Portable.exe"
Icon "${APP}.ico"

Function FixVar
	; === Fix variable if running on x64 machine ===
	StrCmp $ARCHITECTURE "x64" "" +8 ; check if running on x64 machine
		IfFileExists "$PROGRAMDIR64\$PROGRAMEXE64" "" +4
			StrCpy $PROGRAMDIR "$PROGRAMDIR64"
			StrCpy $PROGRAMEXE "$PROGRAMEXE64"
			Goto +4
		IfFileExists "$PROGRAMDIR\$PROGRAMEXE" +3
			StrCpy $PROGRAMDIR "$PROGRAMDIR64"
			StrCpy $PROGRAMEXE "$PROGRAMEXE64"
FunctionEnd

Function Init
	; === Backup local registry keys ===
	${registry::BackupLocal} "${REGKEY1}"

	; === Restore portable registry keys ===
	${registry::RestorePortable}

	; === Force to use default settings ===
	WriteRegStr HKEY_CURRENT_USER "Software\PowerISO" "Install_Dir" "$PROGRAMDIR"
	WriteRegDWORD HKEY_CURRENT_USER "Software\PowerISO" "CheckUpgrade" 0x80000000
	WriteRegDWORD HKEY_CURRENT_USER "Software\PowerISO" "ShellIntegration" 0x0
	WriteRegDWORD HKEY_CURRENT_USER "Software\PowerISO\SCDEmu" "FLAGS" 0x4

	; === TempPath ===
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "TempPath"
	StrCmp $0 "" "" +3
		WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "TempPath" "temp"
		StrCpy $0 "temp"
	StrCmp $0 "temp" "" +3
		CreateDirectory "$TEMPDIR"
			WriteRegStr HKEY_CURRENT_USER "Software\PowerISO" "TempFolder" "$TEMPDIR"
	StrCmp $0 "portable" "" +3
		CreateDirectory "$SETTINGSDIR\temp"
			WriteRegStr HKEY_CURRENT_USER "Software\PowerISO" "TempFolder" "$SETTINGSDIR\temp"

	; === Medicine ===
	WriteRegBin HKEY_CURRENT_USER "Software\PowerISO" "USER" "000C5065726B65646C65417070734EFC800508781205ED940A09A5A00F73"
FunctionEnd

Section "Main"
	Call DefaultVar

	Call FixVar

	Call CheckStart

	Call Init

	; === UserDefaultLang ===
	; Launcher will change app language according Windows language,
	; see also: http://medicinecollections.zat.su/lngcode.html
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "UserDefaultLang"
	StrCmp $0 "" "" +3
		WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "UserDefaultLang" "true"
		StrCpy $0 "true"
	StrCmp $0 "true" "" +2
		WriteRegDWORD HKEY_CURRENT_USER "Software\PowerISO" "Language" "$LANGID"

	Call RuntimeData

	Call SplashScreen

	; === Launch ===
	SetOutPath "$PROGRAMDIR" ; lock rename!
	StrCmp `$PARAMETERS` `` LaunchWithoutParameters LaunchWithParameters
	LaunchWithoutParameters:
		ExecWait `"$PROGRAMDIR\$PROGRAMEXE"$PROGRAMSWITCH`
		Goto CheckStillRunning
	LaunchWithParameters:
		ExecWait `"$PROGRAMDIR\$PROGRAMEXE"$PROGRAMSWITCH $PARAMETERS`
	CheckStillRunning:
		; Wait until app closed:
		FindProcDLL::WaitProcEnd "$PROGRAMEXE" -1 ; FindProcDLL modified by hnedka
		FindProcDLL::FindProc "$PROGRAMEXE"
		StrCmp $R0 "1" "" +3
			Sleep 2000
			Goto -3

	Call Close

	Call TheEnd
SectionEnd

Function Close
	; === Remove medicine ===
	DeleteRegValue HKEY_CURRENT_USER "Software\PowerISO" "USER"

	; === Remove temporary directory if set in temp ===
	ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "TempPath"
	StrCmp $0 "temp" "" +2
		RMDir /r "$TEMPDIR"

	; === Backup portable registry keys ===
	Delete "$EXEDIR\Data\${APP}.reg"
	CreateDirectory "$EXEDIR\Data"
		${registry::BackupPortable} "${REGKEY1}"

	; === Restore local registry keys ===
	${registry::RestoreLocal} "${REGKEY1}"
FunctionEnd

Function TheEnd
	; === Unload plug-ins ===
	newadvsplash::stop ; unload splash screen
	registry::_Unload ; unload registry plug-in

	; === Remove runtime data ===
	FileClose $RUNTIMEDATA ; unlock file
		Delete "$EXEDIR\Data\${APP}PortableRuntimeData.ini"
FunctionEnd
